<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Player extends Model 
{

    protected $table = 'players';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('address', 'post_code', 'sru_number', 'tel_no', 'mob_no', 'kin', 'issues');

    public function user()
    {
        return $this->belongsTo('\User');
    }

}